CREATE TABLE IF NOT EXISTS `afterbuy_catalogs` (
       `catalog_id` int NOT NULL,
       `parent_id` int NOT NULL,
       `name` varchar(255) NOT NULL,
       `description` text NOT NULL,
       `level` int NOT NULL DEFAULT '0',
       `position` int NOT NULL DEFAULT '0',
       `additionaltext` varchar(255) NOT NULL,
       `show_catalog` tinyint(1) NOT NULL DEFAULT '0',
       `picture1` varchar(255) NOT NULL,
       `picture2` varchar(255) NOT NULL,
       `titlepicture` varchar(255) NOT NULL,
       PRIMARY KEY (`catalog_id`)
      ) ENGINE=InnoDB DEFAULT CHARSET=`utf8`;

CREATE TABLE IF NOT EXISTS `afterbuy_catalogs_to_categories` (
        `catalog_id` int NOT NULL,
        `category_id` int NOT NULL,
        PRIMARY KEY (`catalog_id`,`category_id`)
       ) ENGINE=InnoDB DEFAULT CHARSET=`utf8`;

CREATE TABLE IF NOT EXISTS `afterbuy_products` (
        `products_id` int NOT NULL,
        `combi_id` int DEFAULT NULL,
        `afterbuy_product_id` int NOT NULL,
        `data_origin` varchar(10) NOT NULL DEFAULT '',
        UNIQUE KEY `afterbuy_product_id` (`afterbuy_product_id`),
        UNIQUE KEY `products_id_2` (`products_id`,`combi_id`)
       ) ENGINE=InnoDB DEFAULT CHARSET=`utf8`;

CREATE TABLE IF NOT EXISTS `afterbuy_products_to_catalogs` (
          `catalog_id` int NOT NULL,
          `product_id` int NOT NULL,
          KEY `catalog_id` (`catalog_id`,`product_id`)
      ) ENGINE=InnoDB DEFAULT CHARSET=`utf8`;

CREATE TABLE IF NOT EXISTS `afterbuy_orders` (
    `id`                INT      NOT NULL AUTO_INCREMENT PRIMARY KEY,
    `order_id`          INT      NOT NULL,
    `afterbuy_order_id` INT      NOT NULL,
    `state`             ENUM ('unprocessed', 'transmitted', 'paid') DEFAULT 'unprocessed',
    `created_at`        DATETIME NOT NULL                           DEFAULT NOW(),
    `modified_at`       DATETIME NOT NULL ON UPDATE NOW()           DEFAULT NOW(),
    UNIQUE KEY `orders_mapping` (`order_id`, `afterbuy_order_id`)
) ENGINE = InnoDB DEFAULT CHARSET = utf8;

